﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="LabResults.aspx.cs" Inherits="LabResults" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    
    <div class="breadcrumb">
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="My Tasks > Lab Results > " />
              <br />
    </div>
    <div class = "excludeSaveWarnings">
    <br />
   <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </div>  
    <asp:GridView ID="GridViewLabResults" runat="server" 
        AllowPaging="True" 
        OnRowCommand="SelectActivity" 
        AutoGenerateColumns="False"  
        DataKeyNames="ActivityId" 
        PageSize = "20" 
        AllowSorting="True">
        <Columns>
             <asp:TemplateField 
                HeaderText="Workflow ID" 
                SortExpression="CaseId">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelCaseId" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseId")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

           <asp:TemplateField HeaderText="Lab Report Date" SortExpression="LabReportDate" Visible="false" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelLabReportDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LabReportDate", "{0:d}")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Entry Date" SortExpression="ReceivedDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelReceivedDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReceivedDate", "{0:d}")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Accepted Date" SortExpression="AcceptedDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelAcceptedDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("AcceptedDate", "{0:MM/dd/yyyy}")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Patient Name" 
                SortExpression="PatientName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientName")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            
            
             <asp:TemplateField 
                HeaderText="Site Number" 
                SortExpression="Site">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelSite" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Site")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Facility" 
                SortExpression="SiteName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelSiteName" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("SiteName")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
              
                
            <asp:TemplateField 
                HeaderText="Specimen Type" 
                SortExpression="CaseType">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelCaseType" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseType")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:ButtonField 
                ButtonType = "Button" 
                Text = "Select" 
                CommandName = "Details"  />
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource ID="ObjectDataSourceGridViewLabResults" runat="server" 
        SelectMethod="GetNewLabResults" 
        onselected="ObjectDataSourceGridViewLabResults_Selected" 
        TypeName="VeteransAffairs.Registries.BusinessManager.LabResultsManager"
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True" >
    <SelectParameters>
        <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
    
    </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>